//=============================================================================
// VisuStella MZ - Animated Message Text Effects
// VisuMZ_2_AniMsgTextEffects.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_AniMsgTextEffects = true;

var VisuMZ = VisuMZ || {};
VisuMZ.AniMsgTextEffects = VisuMZ.AniMsgTextEffects || {};
VisuMZ.AniMsgTextEffects.version = 1.02;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.02] [AniMsgTextEffects]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Animated_Message_Text_Effects_VisuStella_MZ
 * @base VisuMZ_1_MessageCore
 * @orderAfter VisuMZ_1_MessageCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * Ever wanted to animate the text that appears in your Message Window in order
 * to add just a bit more character to their lines? Perhaps a stagger effect or
 * a shivering effect? Maybe a swinging effect like a pendulum or a glowing
 * effect for a specific color? This plugin comes with a plethora of text
 * effects to pick and use from in addition to letting you create your very own
 * custom text effects through the Plugin Parameters and just by adjusting the
 * various effect properties.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Animate text shown in the Message Window with more than 40+ number of
 *   custom text effects with many having three different variations each.
 * * Add in your own custom text effects or modify existing text effects. There
 *   is an endless number of custom text effects you can add.
 * * Options command for players to turn on/off Message Text Effects in case
 *   the text effects may interfere with their ability to read.
 * * Angle-type text effects will sway back and forth by the angle or
 *   constantly spin in a certain direction.
 * * Color-type text effects will allow for hue shifts or color tone patterns
 *   to be applied to your message text.
 * * Opacity-type text effects can cause the opacity of a letter to fade in/out
 *   and/or use custom opacity patterns that can also be used to determine
 *   fade level.
 * * Positioning-type text effects can shake randomly in specified directions
 *   or move back and forth for specified directions in a wave.
 * * Scaling-type text effects can flip to its front and back sides or grow
 *   and shrink in size by a certain amount like a pulse.
 * * You can combine text effects with one another as long as they are of
 *   different types.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_MessageCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Available Text Codes
 * ============================================================================
 *
 * The following are text codes that you may use with this plugin.
 * 
 * While the \Effect<name> part of the text code is hardcoded, the actual
 * settings for each of the text effect types can be modified through the
 * Plugin Parameters.
 * 
 * These Text Effects can ONLY be used for the Message Window and nothing else.
 * Everything else will have the text be displayed normally. This means you
 * CANNOT use Animated Message Text Effects for the Help Window, Choice Window,
 * Status Window, etc. Only the main Message Window can support them.
 * 
 * ---
 *
 * === General Text Effect-Related Text Codes ===
 * 
 * ---
 *
 * --------------------   -----------------------------------------------------
 * Text Code              Animated Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<name>          Changes the text effect to "name" where "name" is
 *                        based on the Plugin Parameter "Name" setting. The
 *                        text effect will then be applied to regular text
 *                        characters and icons. Other visual text code graphics
 *                        won't have custom text effects applied to them.
 * 
 * \Effect<Normal>        Returns the text effect type to "normal". No shaking,
 *                        angle changing, etc. effects will be seen. Just plain
 *                        old normal text.
 * 
 * <Clear Effect>         Same as \Effect<Normal> as it will return the text
 *                        effect type to "normal". There are no differences
 *                        between usage as it is up to personal preference on
 *                        which you want to use.
 * 
 * ---
 *
 * === Angle-Type Text Effect-Related Text Codes ===
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Pendulum-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Swing>         Angle of letters swing uniformly back and forth.
 * \Effect<SlowSwing>     Slower version of "Swing" text effect.
 * \Effect<FastSwing>     Faster version of "Swing" text effect.
 * 
 * \Effect<Wag>           Angle of letters swing in a sequence back and forth.
 * \Effect<SlowWag>       Slower version of "Wag" text effect.
 * \Effect<FastWag>       Faster version of "Wag" text effect.
 * 
 * \Effect<Jelly>         Angle and position move back and forth in a sequence.
 * \Effect<SlowJelly>     Slower version of "Jelly" text effect.
 * \Effect<FastJelly>     Faster version of "Jelly" text effect.
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Rotation-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<SpinCW>        Letters rotate clockwise uniformly.
 * \Effect<SlowSpinCW>    Slower version of "SpinCW" text effect.
 * \Effect<FastSpinCW>    Faster version of "SpinCW" text effect.
 * 
 * \Effect<SpinCCW>       Letters rotate counter-clockwise uniformly.
 * \Effect<SlowSpinCCW>   Slower version of "SpinCCW" text effect.
 * \Effect<FastSpinCCW>   Faster version of "SpinCCW" text effect.
 * 
 * \Effect<RollCW>        Letters rotate clockwise in a sequence.
 * \Effect<SlowRollCW>    Slower version of "RollCW" text effect.
 * \Effect<FastRollCW>    Faster version of "RollCW" text effect.
 * 
 * \Effect<RollCCW>       Letters rotate counter-clockwise in a sequence.
 * \Effect<SlowRollCCW>   Slower version of "RollCCW" text effect.
 * \Effect<FastRollCCW>   Faster version of "RollCCW" text effect.
 * 
 * ---
 *
 * === Color-Type Text Effect-Related Text Codes ===
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Hue-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Prism>         Letters will hue shift uniformly.
 * \Effect<SlowPrism>     Slower version of "Prism" text effect.
 * \Effect<FastPrism>     Faster version of "Prism" text effect.
 * 
 * \Effect<Rainbow>       Letters will hue shift in a sequence.
 * \Effect<SlowRainbow>   Slower version of "Rainbow" text effect.
 * \Effect<FastRainbow>   Faster version of "Rainbow" text effect.
 * 
 * \Effect<Gamer>         Letters will hue shift in a stagger.
 * \Effect<SlowGamer>     Slower version of "Gamer" text effect.
 * \Effect<FastGamer>     Faster version of "Gamer" text effect.
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Tone-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Red>           A static red tone on the text.
 * \Effect<SoftRed>       Smoothly transition red tone on the text.
 * \Effect<HardRed>       Instant transition red tone on the text.
 * 
 * \Effect<Green>         A static green tone on the text.
 * \Effect<SoftGreen>     Smoothly transition green tone on the text.
 * \Effect<HardGreen>     Instant transition green tone on the text.
 * 
 * \Effect<Blue>          A static blue tone on the text.
 * \Effect<SoftBlue>      Smoothly transition blue tone on the text.
 * \Effect<HardBlue>      Instant transition blue tone on the text.
 * 
 * \Effect<Yellow>        A static yellow tone on the text.
 * \Effect<SoftYellow>    Smoothly transition yellow tone on the text.
 * \Effect<HardYellow>    Instant transition yellow tone on the text.
 * 
 * \Effect<Cyan>          A static cyan tone on the text.
 * \Effect<SoftCyan>      Smoothly transition cyan tone on the text.
 * \Effect<HardCyan>      Instant transition cyan tone on the text.
 * 
 * \Effect<Magenta>       A static magenta tone on the text.
 * \Effect<SoftMagenta>   Smoothly transition magenta tone on the text.
 * \Effect<HardMagenta>   Instant transition magenta tone on the text.
 * 
 * \Effect<RGB>           Smooth shifting RGB tones in a sequence.
 * \Effect<SlowRGB>       Slower version of "RGB" text effect.
 * \Effect<FastRGB>       Faster version of "RGB" text effect.
 * 
 * \Effect<Fes>           Instant shifting Red/Green tones in a sequence.
 * \Effect<SlowFes>       Slower version of "Fes" text effect.
 * \Effect<FastFes>       Faster version of "Fes" text effect.
 * 
 * \Effect<Gig>           Smooth shifting base tones in a sequence.
 * \Effect<SlowGig>       Slower version of "Gig" text effect.
 * \Effect<FastGig>       Faster version of "Gig" text effect.
 * 
 * ---
 *
 * === Opacity-Type Text Effect-Related Text Codes ===
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Glow-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Glow>          Letters fade in and out uniformly.
 * \Effect<SlowGlow>      Slower version of "Glow" text effect.
 * \Effect<FastGlow>      Faster version of "Glow" text effect.
 * 
 * \Effect<Flow>          Letters fade in and out in a sequence.
 * \Effect<SlowFlow>      Slower version of "Flow" text effect.
 * \Effect<FastFlow>      Faster version of "Flow" text effect.
 * 
 * \Effect<Blink>         Letters blink in and out in a stagger.
 * \Effect<SlowBlink>     Slower version of "Blink" text effect.
 * \Effect<FastBlink>     Faster version of "Blink" text effect.
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Pattern-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Campfire>      A specified blinking light pattern for letters.
 * \Effect<Candle>        A specified blinking light pattern for letters.
 * \Effect<Fade>          A specified blinking light pattern for letters.
 * \Effect<Flicker>       A specified blinking light pattern for letters.
 * \Effect<Fluorescent>   A specified blinking light pattern for letters.
 * \Effect<Halogen>       A specified blinking light pattern for letters.
 * \Effect<Strobe>        A specified blinking light pattern for letters.
 * \Effect<Torch>         A specified blinking light pattern for letters.
 * \Effect<Underwater>    A specified blinking light pattern for letters.
 * 
 * ---
 *
 * === Position-Type Text Effect-Related Text Codes ===
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Frantic-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Shake>         Shakes frantically and randomly in any direction.
 * \Effect<SoftShake>     Less frantic version of "Shake" text effect.
 * \Effect<HardShake>     More frantic version of "Shake" text effect.
 * 
 * \Effect<Shiver>        Shivers frantically in the left/right direction.
 * \Effect<SoftShiver>    Less frantic version of "Shiver" text effect.
 * \Effect<HardShiver>    More frantic version of "Shiver" text effect.
 * 
 * \Effect<Vibe>          Vibrates frantically in the up/down direction.
 * \Effect<SoftVibe>      Less frantic version of "Vibe" text effect.
 * \Effect<HardVibe>      More frantic version of "Vibe" text effect.
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Wave-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Stagger>       Moves with letters staggered up and down.
 * \Effect<SlowStagger>   Slower version of "Stagger" text effect.
 * \Effect<FastStagger>   Faster version of "Stagger" text effect.
 * 
 * \Effect<Saw>           Moves uniformly left and right.
 * \Effect<SlowSaw>       Slower version of "Saw" text effect.
 * \Effect<FastSaw>       Faster version of "Saw" text effect.
 * 
 * \Effect<Bounce>        Moves uniformly up and down.
 * \Effect<SlowBounce>    Slower version of "Bounce" text effect.
 * \Effect<FastBounce>    Faster version of "Bounce" text effect.
 * 
 * \Effect<Wave>          Waves by letter in all directions.
 * \Effect<SlowWave>      Slower version of "Wave" text effect.
 * \Effect<FastWave>      Faster version of "Wave" text effect.
 * 
 * \Effect<HorzWave>      Waves by letter in horizontal direction.
 * \Effect<SlowHorzWave>  Slower version of "HorzWave" text effect.
 * \Effect<FastHorzWave>  Faster version of "HorzWave" text effect.
 * 
 * \Effect<VertWave>      Waves by letter in vertical direction.
 * \Effect<SlowVertWave>  Slower version of "VertWave" text effect.
 * \Effect<FastVertWave>  Faster version of "VertWave" text effect.
 * 
 * ---
 *
 * === Scaling-Type Text Effect-Related Text Codes ===
 * 
 * ---
 * 
 * ----------------------   ---------------------------------------------------
 * Text Code                Flip-Subtype Text Effect (Message Window Only)
 * ----------------------   ---------------------------------------------------
 * 
 * \Effect<HorzCard>        Horizontally uniform flipping effect.
 * \Effect<SlowHorzCard>    Slower version of "HorzCard" text effect.
 * \Effect<FastHorzCard>    Faster version of "HorzCard" text effect.
 * 
 * \Effect<VertCard>        Vertically uniform flipping effect.
 * \Effect<SlowVertCard>    Slower version of "VertCard" text effect.
 * \Effect<FastVertCard>    Faster version of "VertCard" text effect.
 * 
 * \Effect<HorzRibbon>      Horizontally folding flipping effect.
 * \Effect<SlowHorzRibbon>  Slower version of "HorzRibbon" text effect.
 * \Effect<FastHorzRibbon>  Faster version of "HorzRibbon" text effect.
 * 
 * \Effect<VertRibbon>      Vertically folding flipping effect.
 * \Effect<SlowVertRibbon>  Slower version of "VertRibbon" text effect.
 * \Effect<FastVertRibbon>  Faster version of "VertRibbon" text effect.
 * 
 * ---
 * 
 * --------------------   -----------------------------------------------------
 * Text Code              Pulse-Subtype Text Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * \Effect<Pulse>         Letters grow bigger and smaller uniformly.
 * \Effect<SmallPulse>    Smaller version of "Pulse" text effect.
 * \Effect<BigPulse>      Larger version of "Pulse" text effect.
 * 
 * \Effect<Jiggle>        Letters grow bigger and smaller in a sequence.
 * \Effect<SmallJiggle>   Smaller version of "Jiggle" text effect.
 * \Effect<BigJiggle>     Larger version of "Jiggle" text effect.
 * 
 * \Effect<Gooey>         Letters grow bigger and smaller in a stretched form.
 * \Effect<SmallGooey>    Smaller version of "Gooey" text effect.
 * \Effect<BigGooey>      Larger version of "Gooey" text effect.
 * 
 * ---
 * 
 * === Combining Text Effects ===
 * 
 * ---
 * 
 * \Effect<type, type>
 * \Effect<type, type, type>
 * \Effect<type, type, type, type>
 * \Effect<type, type, type, type, type>
 * 
 * You can combine text effects with one another provided that they are of
 * different types (NOT subtypes). What this means is you can pick an
 * angle-type text effect, combine it with a color-type text effect along with
 * something like a positioning-type text effect and produce results.
 * 
 * You cannot combine same types together such as a positioning-type with
 * another positioning type.
 * 
 * Examples:
 * 
 * \Effect<Swing, Rainbow>
 * \Effect<Wag, Flow, HorzWave>
 * \Effect<Jelly, Shiver, HorzCard>
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Angle Effects Settings
 * ============================================================================
 *
 * Setup the various settings for angle-type Text Effects here.
 *
 * ---
 *
 * General
 * 
 *   Name:
 *   - UNIQUE name of this message text effect type.
 *   - Used in place of 'name' in \Effect<name> for text codes.
 *
 * ---
 * 
 * Angles > Pendulum Effect
 * 
 *   Arc Size:
 *   - What is the pendulum arc size?
 * 
 *   Speed Modifier:
 *   - Arc speed rate for pendulum effect.
 * 
 *   Offset Modifier:
 *   - Arc offset modifier for pendulum effect.
 * 
 * ---
 * 
 * Angles > Rotation Effect
 * 
 *   Speed Modifier:
 *   - Speed to determine many angles will rotate per frame.
 * 
 *   Offset Modifier:
 *   - Initial angle offset modifier for rotation effect.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Color Effects Settings
 * ============================================================================
 *
 * Setup the various settings for color-type Text Effects here.
 *
 * ---
 *
 * General
 * 
 *   Name:
 *   - UNIQUE name of this message text effect type.
 *   - Used in place of 'name' in \Effect<name> for text codes.
 *
 * ---
 *
 * Color
 * 
 *   Forced Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 *   - Leave empty to not use.
 * 
 * ---
 * 
 * Color > Hue Change Effect
 * 
 *   Hue Shift:
 *   - Shift hue by how much each frame?
 * 
 *   Offset Modifier:
 *   - Initial hue offset modifier for hue shift.
 * 
 * ---
 * 
 * Color > Tone Effect
 * 
 *   Color Tone(s):
 *   - What tone(s) do you want for the letters?
 *   - Format: [Red, Green, Blue, Gray]
 * 
 *   Frame Delay:
 *   - What is the frame delay between tone changes?
 * 
 *   Offset Modifier:
 *   - Initial tone offset modifier for tone change.
 * 
 *   Smooth Transition?:
 *   - Make a smooth transition for tone changes?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Opacity Effects Settings
 * ============================================================================
 *
 * Setup the various settings for opacity-type Text Effects here.
 *
 * ---
 *
 * General
 * 
 *   Name:
 *   - UNIQUE name of this message text effect type.
 *   - Used in place of 'name' in \Effect<name> for text codes.
 *
 * ---
 * 
 * Opacity
 * 
 *   Base Opacity:
 *   - What is the starting opacity value?
 * 
 * ---
 * 
 * Opacity > Glow Effect
 * 
 *   Glow Rate:
 *   - What is the glow change for this effect?
 *   - Use a decimal number between 0 and 1.
 * 
 *   Glow Speed:
 *   - What is the speed at which glow oscillates at?
 *   - Use a decimal number between 0 and 1.
 * 
 *   Offset Modifier:
 *   - Initial opacity offset modifier for glow effect.
 * 
 * ---
 * 
 * Opacity > Intensity Pattern
 * 
 *   Custom Pattern:
 *   - Create a custom pattern with letters from a to z.
 *   - Where 'a' is transparent and 'z' is opaque.
 * 
 *   Frame Delay:
 *   - What is the frame delay between pattern updates?
 * 
 *   Offset Modifier:
 *   - Initial opacity offset modifier for pattern effect.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Positioning Effects Settings
 * ============================================================================
 *
 * Setup the various settings for positioning-type Text Effects here.
 *
 * ---
 *
 * General
 * 
 *   Name:
 *   - UNIQUE name of this message text effect type.
 *   - Used in place of 'name' in \Effect<name> for text codes.
 *
 * ---
 *
 * Positioning > Wave (Horz) Effect
 * 
 *   Distance:
 *   - Horizontal distance for wave effect.
 * 
 *   Speed Modifier:
 *   - Horizontal speed rate for wave effect.
 * 
 *   Offset Modifier:
 *   - Horizontal offset modifier for wave effect.
 * 
 * ---
 * 
 * Positioning > Wave (Vert) Effect
 * 
 *   Distance:
 *   - Vertical distance for wave effect.
 * 
 *   Speed Modifier:
 *   - Vertical speed rate for wave effect.
 * 
 *   Offset Modifier:
 *   - Vertical offset modifier for wave effect.
 * 
 * ---
 *
 * Positioning > Frantic Effect
 * 
 *   Horz Strength:
 *   - Horizontal frantic randomization strength.
 *   - Determines random horizontal position for frantic effect.
 * 
 *   Vert Strength:
 *   - Vertical frantic randomization strength.
 *   - Determines random vertical position for frantic effect.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Scaling Effects Settings
 * ============================================================================
 *
 * Setup the various settings for scaling-type Text Effects here.
 *
 * ---
 *
 * General
 * 
 *   Name:
 *   - UNIQUE name of this message text effect type.
 *   - Used in place of 'name' in \Effect<name> for text codes.
 *
 * ---
 * 
 * Scaling > Flip (Horz) Effect
 * 
 *   Speed Modifier:
 *   - Horizontal speed rate for flip effect.
 * 
 *   Offset Modifier:
 *   - Horizontal offset modifier for flip effect.
 * 
 * ---
 * 
 * Scaling > Flip (Vert) Effect
 * 
 *   Speed Modifier:
 *   - Vertical speed rate for flip effect.
 * 
 *   Offset Modifier:
 *   - Vertical offset modifier for flip effect.
 * 
 * ---
 * 
 * Scaling > Pulse (Horz) Effect
 * 
 *   Growth:
 *   - Horizontal growth pulse effect.
 * 
 *   Speed Modifier:
 *   - Horizontal speed rate for pulse effect.
 * 
 *   Offset Modifier:
 *   - Horizontal offset modifier for pulse effect.
 * 
 * ---
 * 
 * Scaling > Pulse (Vert) Effect
 * 
 *   Growth:
 *   - Vertical growth pulse effect.
 * 
 *   Speed Modifier:
 *   - Vertical speed rate for pulse effect.
 * 
 *   Offset Modifier:
 *   - Vertical offset modifier for pulse effect.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Settings
 * ============================================================================
 *
 * Options settings for Animated Message Text Effects.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Animated Text Effects' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Irina
 * * Arisu
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.02: March 16, 2023
 * * Bug Fixes!
 * ** Animated text that has been sized up with \{ text codes will no longer be
 *    cut off visually, especially with larger outline effects and certain font
 *    types. Fix made by Irina.
 * 
 * Version 1.01: February 16, 2023
 * * Bug Fixes!
 * ** <Clear Effect> text code was not working properly before. Now, it should
 *    work fine and clear effects. Fix made by Irina.
 * ** Color Tone effects applied to large quantities of text should no longer
 *    cause interrupted breaks. Fix made by Irina.
 * 
 * Version 1.00 Official Release Date: February 27, 2023
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AniMsgTextEffects
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 * 
 * @param TextEffects
 * @text Text Effect Settings
 *
 * @param AngleEffects:arraystruct
 * @text Angle Effects
 * @parent TextEffects
 * @type struct<AngleEffect>[]
 * @desc Setup the various settings for angle-type Text Effects here.
 * @default ["{\"Name:str\":\"Swing\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.25\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SlowSwing\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.10\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"FastSwing\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.40\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"Wag\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.25\",\"PendulumOffset:num\":\"8\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SlowWag\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.10\",\"PendulumOffset:num\":\"8\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"FastWag\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.40\",\"PendulumOffset:num\":\"8\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"Jelly\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.25\",\"PendulumOffset:num\":\"15\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SlowJelly\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.10\",\"PendulumOffset:num\":\"15\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"FastJelly\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"15\",\"PendulumSpeed:num\":\"0.40\",\"PendulumOffset:num\":\"12\",\"Rotation\":\"\",\"RotationSpeed:num\":\"0\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SpinCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-2.4\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SlowSpinCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-1.8\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"FastSpinCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-3.6\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SpinCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+2.4\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"SlowSpinCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+1.8\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"FastSpinCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+3.6\",\"RotationOffset:num\":\"0\"}","{\"Name:str\":\"RollCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-2.4\",\"RotationOffset:num\":\"-12\"}","{\"Name:str\":\"SlowRollCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-1.8\",\"RotationOffset:num\":\"-9\"}","{\"Name:str\":\"FastRollCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"-3.6\",\"RotationOffset:num\":\"-15\"}","{\"Name:str\":\"RollCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+2.4\",\"RotationOffset:num\":\"12\"}","{\"Name:str\":\"SlowRollCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+1.8\",\"RotationOffset:num\":\"9\"}","{\"Name:str\":\"FastRollCCW\",\"Angles\":\"\",\"Pendulum\":\"\",\"PendulumArc:num\":\"0\",\"PendulumSpeed:num\":\"0\",\"PendulumOffset:num\":\"0\",\"Rotation\":\"\",\"RotationSpeed:num\":\"+3.6\",\"RotationOffset:num\":\"15\"}"]
 *
 * @param ColorEffects:arraystruct
 * @text Color Effects
 * @parent TextEffects
 * @type struct<ColorEffect>[]
 * @desc Setup the various settings for color-type Text Effects here.
 * @default ["{\"Name:str\":\"Prism\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-6\",\"InitialHueOffset:num\":\"0\"}","{\"Name:str\":\"SlowPrism\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-3\",\"InitialHueOffset:num\":\"0\"}","{\"Name:str\":\"FastPrism\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-9\",\"InitialHueOffset:num\":\"0\"}","{\"Name:str\":\"Rainbow\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-6\",\"InitialHueOffset:num\":\"36\"}","{\"Name:str\":\"SlowRainbow\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-3\",\"InitialHueOffset:num\":\"36\"}","{\"Name:str\":\"FastRainbow\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-9\",\"InitialHueOffset:num\":\"36\"}","{\"Name:str\":\"Gamer\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-6\",\"InitialHueOffset:num\":\"-216\"}","{\"Name:str\":\"SlowGamer\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-3\",\"InitialHueOffset:num\":\"-216\"}","{\"Name:str\":\"FastGamer\",\"Color\":\"\",\"ForcedColor:str\":\"#f69679\",\"Hue\":\"\",\"HueShift:num\":\"-9\",\"InitialHueOffset:num\":\"-216\"}","{\"Name:str\":\"Red\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftRed\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardRed\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Green\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftGreen\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardGreen\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Blue\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftBlue\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 0, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardBlue\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 0, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Yellow\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 255, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftYellow\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 255, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardYellow\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 255, 0, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Cyan\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 255, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftCyan\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardCyan\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[0, 255, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Magenta\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SoftMagenta\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"HardMagenta\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 255, 0]\\\",\\\"[0, 0, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"0\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"RGB\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[255, 255, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 255, 255, 0]\\\",\\\"[0, 0, 255, 0]\\\",\\\"[255, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"20\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"SlowRGB\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[255, 255, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 255, 255, 0]\\\",\\\"[0, 0, 255, 0]\\\",\\\"[255, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"FastRGB\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[255, 255, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 255, 255, 0]\\\",\\\"[0, 0, 255, 0]\\\",\\\"[255, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"10\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"Fes\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\"]\",\"toneDelay:num\":\"20\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"SlowFes\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"FastFes\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\"]\",\"toneDelay:num\":\"10\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"false\"}","{\"Name:str\":\"Gig\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"20\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"SlowGig\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"30\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}","{\"Name:str\":\"FastGig\",\"Color\":\"\",\"ForcedColor:str\":\"\",\"Hue\":\"\",\"HueShift:num\":\"0\",\"InitialHueOffset:num\":\"0\",\"Tone\":\"\",\"colorTones:arrayeval\":\"[\\\"[255, 0, 0, 0]\\\",\\\"[0, 255, 0, 0]\\\",\\\"[0, 0, 255, 0]\\\"]\",\"toneDelay:num\":\"10\",\"InitialToneOffset:num\":\"-1\",\"SmoothToneChange:eval\":\"true\"}"]
 *
 * @param OpacityEffects:arraystruct
 * @text Opacity Effects
 * @parent TextEffects
 * @type struct<OpacityEffect>[]
 * @desc Setup the various settings for opacity-type Text Effects here.
 * @default ["{\"Name:str\":\"Glow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.25\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"SlowGlow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.10\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"FastGlow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.40\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Flow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.25\",\"glowOffset:num\":\"2\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"SlowFlow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.10\",\"glowOffset:num\":\"2\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"FastFlow\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.40\",\"glowOffset:num\":\"2\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Blink\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.25\",\"glowOffset:num\":\"15\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"SlowBlink\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.10\",\"glowOffset:num\":\"30\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"FastBlink\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0.50\",\"glowSpeed:num\":\"0.40\",\"glowOffset:num\":\"8\",\"Pattern\":\"\",\"pattern:str\":\"\",\"patternDelay:num\":\"0\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Campfire\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa\",\"patternDelay:num\":\"2\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Candle\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmmmmaaaaammmmmaaaaaabcdefgabcdefg\",\"patternDelay:num\":\"2\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Fade\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"abcdefghijklmnopqrrqponmlkjihgfedcba\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Flicker\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"nmonqnmomnmomomno\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Fluorescent\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmamammmmammamamaaamammma\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Halogen\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmnmmommommnonmmonqnmmo\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Strobe\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mamamamamama\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Torch\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmmaaaabcdefgmmmmaaaammmaamm\",\"patternDelay:num\":\"2\",\"patternOffset:num\":\"0\"}","{\"Name:str\":\"Underwater\",\"Opacity\":\"\",\"InitialOpacity:num\":\"255\",\"Glow\":\"\",\"glowRate:num\":\"0\",\"glowSpeed:num\":\"0\",\"glowOffset:num\":\"0\",\"Pattern\":\"\",\"pattern:str\":\"mmnnmmnnnmmnn\",\"patternDelay:num\":\"4\",\"patternOffset:num\":\"0\"}"]
 *
 * @param PositionEffects:arraystruct
 * @text Positioning Effects
 * @parent TextEffects
 * @type struct<PositionEffect>[]
 * @desc Setup the various settings for color-type Text Effects here.
 * @default ["{\"Name:str\":\"Shake\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"2\",\"ShakeStrengthVert:num\":\"2\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SoftShake\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"1\",\"ShakeStrengthVert:num\":\"1\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"HardShake\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"3\",\"ShakeStrengthVert:num\":\"3\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"Shiver\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"2\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SoftShiver\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"1\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"HardShiver\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"3\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"Vibe\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"2\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SoftVibe\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"1\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"HardVibe\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"3\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"Stagger\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"4\",\"WaveSpeedY:num\":\"0.25\",\"WaveOffsetY:num\":\"15\"}","{\"Name:str\":\"SlowStagger\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"4\",\"WaveSpeedY:num\":\"0.10\",\"WaveOffsetY:num\":\"30\"}","{\"Name:str\":\"FastStagger\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"4\",\"WaveSpeedY:num\":\"0.50\",\"WaveOffsetY:num\":\"30\"}","{\"Name:str\":\"Saw\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.25\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowSaw\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.10\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"FastSaw\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.40\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"Bounce\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.25\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowBounce\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.10\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"FastBounce\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.40\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"Wave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.25\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.25\",\"WaveOffsetY:num\":\"2\"}","{\"Name:str\":\"SlowWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.10\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.10\",\"WaveOffsetY:num\":\"2\"}","{\"Name:str\":\"FastWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.40\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.40\",\"WaveOffsetY:num\":\"2\"}","{\"Name:str\":\"HorzWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.25\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowHorzWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.10\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"FastHorzWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"3\",\"WaveSpeedX:num\":\"0.40\",\"WaveOffsetX:num\":\"1\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"0\",\"WaveSpeedY:num\":\"0\",\"WaveOffsetY:num\":\"0\"}","{\"Name:str\":\"VertWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.25\",\"WaveOffsetY:num\":\"2\"}","{\"Name:str\":\"SlowVertWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.10\",\"WaveOffsetY:num\":\"2\"}","{\"Name:str\":\"FastVertWave\",\"Positioning\":\"\",\"Shake\":\"\",\"ShakeStrengthHorz:num\":\"0\",\"ShakeStrengthVert:num\":\"0\",\"WaveX\":\"\",\"WaveDistanceX:num\":\"0\",\"WaveSpeedX:num\":\"0\",\"WaveOffsetX:num\":\"0\",\"WaveY\":\"\",\"WaveDistanceY:num\":\"3\",\"WaveSpeedY:num\":\"0.40\",\"WaveOffsetY:num\":\"2\"}"]
 *
 * @param ScaleEffects:arraystruct
 * @text Scaling Effects
 * @parent TextEffects
 * @type struct<ScaleEffects>[]
 * @desc Setup the various settings for color-type Text Effects here.
 * @default ["{\"Name:str\":\"HorzCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.10\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowHorzCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.08\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"FastHorzCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.15\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"VertCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.10\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowVertCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.08\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"FastVertCard\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.15\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"HorzRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.10\",\"FlipOffsetX:num\":\"2\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowHorzRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.08\",\"FlipOffsetX:num\":\"2\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"FastHorzRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0.15\",\"FlipOffsetX:num\":\"2\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"VertRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.10\",\"FlipOffsetY:num\":\"2\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"SlowVertRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.08\",\"FlipOffsetY:num\":\"2\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"FastVertRibbon\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0.15\",\"FlipOffsetY:num\":\"2\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0\",\"PulseSpeedX:num\":\"0\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0\",\"PulseSpeedY:num\":\"0\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"Pulse\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.30\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.30\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"SmallPulse\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.10\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.10\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"BigPulse\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.40\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"0\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.40\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"0\"}","{\"Name:str\":\"Jiggle\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.30\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"2\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.30\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"2\"}","{\"Name:str\":\"SmallJiggle\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.10\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"2\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.10\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"2\"}","{\"Name:str\":\"BigJiggle\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.40\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"2\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"0.40\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"2\"}","{\"Name:str\":\"Gooey\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.30\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"33\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"-0.30\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"33\"}","{\"Name:str\":\"SmallGooey\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.10\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"33\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"-0.10\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"33\"}","{\"Name:str\":\"BigGooey\",\"Scaling\":\"\",\"FlipX\":\"\",\"FlipSpeedX:num\":\"0\",\"FlipOffsetX:num\":\"0\",\"FlipY\":\"\",\"FlipSpeedY:num\":\"0\",\"FlipOffsetY:num\":\"0\",\"PulseX\":\"\",\"PulseGrowthX:num\":\"0.40\",\"PulseSpeedX:num\":\"0.25\",\"PulseOffsetX:num\":\"33\",\"PulseY\":\"\",\"PulseGrowthY:num\":\"-0.40\",\"PulseSpeedY:num\":\"0.25\",\"PulseOffsetY:num\":\"33\"}"]
 *
 * @param Options:struct
 * @text Options Settings
 * @type struct<Options>
 * @desc Options settings for Animated Message Text Effects.
 * @default {"Options":"","AddOption:eval":"true","AdjustRect:eval":"true","Name:str":"Text Effects"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Angle Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AngleEffect:
 *
 * @param Name:str
 * @text Name
 * @desc UNIQUE name of this message text effect type.
 * Used in place of 'name' in \Effect<name> for text codes.
 * @default Untitled
 * 
 * @param Angles
 * 
 * @param Pendulum
 * @text Pendulum Effect
 * @parent Angles
 *
 * @param PendulumArc:num
 * @text Arc Size
 * @parent Pendulum
 * @type number
 * @desc What is the pendulum arc size?
 * @default 0
 *
 * @param PendulumSpeed:num
 * @text Speed Modifier
 * @parent Pendulum
 * @desc Arc speed rate for pendulum effect.
 * @default 0
 *
 * @param PendulumOffset:num
 * @text Offset Modifier
 * @parent Pendulum
 * @desc Arc offset modifier for pendulum effect.
 * @default 0
 * 
 * @param Rotation
 * @text Rotation Effect
 * @parent Angles
 *
 * @param RotationSpeed:num
 * @text Speed Modifier
 * @parent Rotation
 * @desc Speed to determine many angles will rotate per frame.
 * @default 0
 *
 * @param RotationOffset:num
 * @text Offset Modifier
 * @parent Rotation
 * @desc Initial angle offset modifier for rotation effect.
 * @default 0
 * 
 */
/* ----------------------------------------------------------------------------
 * Color Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ColorEffect:
 *
 * @param Name:str
 * @text Name
 * @desc UNIQUE name of this message text effect type.
 * Used in place of 'name' in \Effect<name> for text codes.
 * @default Untitled
 * 
 * @param Color
 *
 * @param ForcedColor:str
 * @text Forced Color
 * @parent Color
 * @desc Use #rrggbb for custom colors or regular numbers for text
 * colors from the Window Skin. Leave empty to not use.
 * @default 
 * 
 * @param Hue
 * @text Hue Change Effect
 * @parent Color
 *
 * @param HueShift:num
 * @text Hue Shift
 * @parent Hue
 * @desc Shift hue by how much each frame?
 * @default 0
 *
 * @param InitialHueOffset:num
 * @text Offset Modifier
 * @parent Hue
 * @desc Initial hue offset modifier for hue shift.
 * @default 0
 * 
 * @param Tone
 * @text Tone Effect
 * @parent Color
 *
 * @param colorTones:arrayeval
 * @text Color Tone(s)
 * @parent Tone
 * @type string[]
 * @desc What tone(s) do you want for the letters?
 * Format: [Red, Green, Blue, Gray]
 * @default []
 *
 * @param toneDelay:num
 * @text Frame Delay
 * @parent Tone
 * @type number
 * @desc What is the frame delay between tone changes?
 * @default 0
 *
 * @param InitialToneOffset:num
 * @text Offset Modifier
 * @parent Tone
 * @desc Initial tone offset modifier for tone change.
 * @default 0
 *
 * @param SmoothToneChange:eval
 * @text Smooth Transition?
 * @parent Tone
 * @type boolean
 * @on Smooth
 * @off Instant
 * @desc Make a smooth transition for tone changes?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Opacity Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OpacityEffect:
 *
 * @param Name:str
 * @text Name
 * @desc UNIQUE name of this message text effect type.
 * Used in place of 'name' in \Effect<name> for text codes.
 * @default Untitled
 * 
 * @param Opacity
 *
 * @param InitialOpacity:num
 * @text Base Opacity
 * @parent Opacity
 * @desc What is the starting opacity value?
 * @default 255
 * 
 * @param Glow
 * @text Glow Effect
 * @parent Opacity
 *
 * @param glowRate:num
 * @text Glow Rate
 * @parent Glow
 * @desc What is the glow change for this effect?
 * Use a decimal number between 0 and 1.
 * @default 0
 *
 * @param glowSpeed:num
 * @text Glow Speed
 * @parent Glow
 * @desc What is the speed at which glow oscillates at?
 * Use a decimal number between 0 and 1.
 * @default 0
 *
 * @param glowOffset:num
 * @text Offset Modifier
 * @parent Glow
 * @desc Initial opacity offset modifier for glow effect.
 * @default 0
 * 
 * @param Pattern
 * @text Intensity Pattern
 * @parent Opacity
 *
 * @param pattern:str
 * @text Custom Pattern
 * @parent Pattern
 * @desc Create a custom pattern with letters from a to z.
 * Where 'a' is transparent and 'z' is opaque.
 * @default 
 *
 * @param patternDelay:num
 * @text Frame Delay
 * @parent Pattern
 * @type number
 * @desc What is the frame delay between pattern updates?
 * @default 0
 *
 * @param patternOffset:num
 * @text Offset Modifier
 * @parent Pattern
 * @desc Initial opacity offset modifier for pattern effect.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Position Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PositionEffect:
 *
 * @param Name:str
 * @text Name
 * @desc UNIQUE name of this message text effect type.
 * Used in place of 'name' in \Effect<name> for text codes.
 * @default Untitled
 * 
 * @param Positioning
 * 
 * @param Shake
 * @text Frantic Effect
 * @parent Positioning
 *
 * @param ShakeStrengthHorz:num
 * @text Horz Strength
 * @parent Shake
 * @type number
 * @desc Horizontal frantic randomization strength.
 * Determines random horizontal position for frantic effect.
 * @default 0
 *
 * @param ShakeStrengthVert:num
 * @text Vert Strength
 * @parent Shake
 * @type number
 * @desc 
 * @default 0
 * 
 * @param WaveX
 * @text Wave (Horz) Effect
 * @parent Positioning
 *
 * @param WaveDistanceX:num
 * @text Distance
 * @parent WaveX
 * @type number
 * @desc Horizontal distance for wave effect.
 * @default 0
 *
 * @param WaveSpeedX:num
 * @text Speed Modifier
 * @parent WaveX
 * @desc Horizontal speed rate for wave effect.
 * @default 0
 *
 * @param WaveOffsetX:num
 * @text Offset Modifier
 * @parent WaveX
 * @desc Horizontal offset modifier for wave effect.
 * @default 0
 * 
 * @param WaveY
 * @text Wave (Vert) Effect
 * @parent Positioning
 *
 * @param WaveDistanceY:num
 * @text Distance
 * @parent WaveY
 * @type number
 * @desc Vertical distance for wave effect.
 * @default 0
 *
 * @param WaveSpeedY:num
 * @text Speed Modifier
 * @parent WaveY
 * @desc Vertical speed rate for wave effect.
 * @default 0
 *
 * @param WaveOffsetY:num
 * @text Offset Modifier
 * @parent WaveY
 * @desc Vertical offset modifier for wave effect.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Scaling Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ScaleEffects:
 *
 * @param Name:str
 * @text Name
 * @desc UNIQUE name of this message text effect type.
 * Used in place of 'name' in \Effect<name> for text codes.
 * @default Untitled
 * 
 * @param Scaling
 * 
 * @param FlipX
 * @text Flip (Horz) Effect
 * @parent Scaling
 *
 * @param FlipSpeedX:num
 * @text Speed Modifier
 * @parent FlipX
 * @desc Horizontal speed rate for flip effect.
 * @default 0
 *
 * @param FlipOffsetX:num
 * @text Offset Modifier
 * @parent FlipX
 * @desc Horizontal offset modifier for flip effect.
 * @default 0
 * 
 * @param FlipY
 * @text Flip (Vert) Effect
 * @parent Scaling
 *
 * @param FlipSpeedY:num
 * @text Speed Modifier
 * @parent FlipY
 * @desc Vertical speed rate for flip effect.
 * @default 0
 *
 * @param FlipOffsetY:num
 * @text Offset Modifier
 * @parent FlipY
 * @desc Vertical offset modifier for flip effect.
 * @default 0
 * 
 * @param PulseX
 * @text Pulse (Horz) Effect
 * @parent Scaling
 *
 * @param PulseGrowthX:num
 * @text Growth
 * @parent PulseX
 * @desc Horizontal growth pulse effect.
 * @default 0
 *
 * @param PulseSpeedX:num
 * @text Speed Modifier
 * @parent PulseX
 * @desc Horizontal speed rate for pulse effect.
 * @default 0
 *
 * @param PulseOffsetX:num
 * @text Offset Modifier
 * @parent PulseX
 * @desc Horizontal offset modifier for pulse effect.
 * @default 0
 * 
 * @param PulseY
 * @text Pulse (Vert) Effect
 * @parent Scaling
 *
 * @param PulseGrowthY:num
 * @text Growth
 * @parent PulseY
 * @desc Vertical growth pulse effect.
 * @default 0
 *
 * @param PulseSpeedY:num
 * @text Speed Modifier
 * @parent PulseY
 * @desc Vertical speed rate for pulse effect.
 * @default 0
 *
 * @param PulseOffsetY:num
 * @text Offset Modifier
 * @parent PulseY
 * @desc Vertical offset modifier for pulse effect.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Options
 * @text Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Text Effects' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Text Effects
 *
 */
//=============================================================================

function _0x175b(){const _0x5edd66=['constructor','addGeneralOptions','toneDelay','parameters','PositionEffects','trim','_textState','prototype','readFlag','height','_baseAngle','angle','map','call','1440MRXMWX','PulseGrowthX','EFFECT','35aPFiMd','patternOffset','outLineColor','_msgWindow','_baseScale','anchor','OpacityEffects','PulseSpeedX','STRUCT','_flipScaleY','format','InitialToneOffset','FlipSpeedY','onDatabaseLoaded','replace','obtainEscapeString','ForcedColor','setupColorModifiers','42156qfdGGi','addCommand','applyOpacityModifiers','applyScaleModifiers','playMessageSound','_pulseScaleY','preFlushTextState','ShakeStrengthVert','removeChild','ARRAYFUNC','setupScaleModifiers','updateFlipY','updatePositionEffects','_textHeight','initialize','match','applyAngleModifiers','addTextEffectsCommands','Scene_Boot_onDatabaseLoaded','_toneIndex','obtainEscapeParam','updatePulseY','AddOption','fontBold','show','updateRotationAngle','iconWidth','6219255wUZTNq','20456xOVugr','updateOpacityPatternEffect','InitialHueOffset','parse','Settings','round','WaveSpeedX','AngleEffects','addTemplatetextEffectsCommand','description','ConvertParams','_textEffect','update','3466592NulGnt','Window_Options_addGeneralOptions','updateAngleEffects','138mYdngU','457554HyMtyl','randomInt','status','glowOffset','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','679877vtnxHi','VisuMZ_3_MessageSounds','Name','filter','fontItalic','name','split','EVAL','_textWidth','setFrame','textEffects','random','224408odRfPC','JSON','bitmap','ScaleEffects','_pendulumAngle','newPage','setupAngleModifiers','updateToneShift','version','create','glowSpeed','_flipScaleX','Options','updateGlowEffect','includes','postFlushTextState','_textEffectData','addWindow','convertTextEffectEscapeCodes','charCodeAt','setColorTone','Window_Base_processDrawIcon','scale','updateWaveX','_currentTone','PulseGrowthY','close','setupOpacityModifiers','ARRAYSTRUCT','clone','_hueValue','ConfigManager_makeData','floor','Window_Message_processEscapeCharacter','STR','pattern','fontSize','Effects','createEffectData','createIconBitmap','_patternIndex','createTextBitmap','FlipOffsetY','preConvertEscapeCharacters','processEscapeCharacter','CLEAREFFECT','glowRate','ARRAYJSON','getColor','makeData','paintOpacity','processDrawIcon','drawing','ARRAYSTR','_pulseScaleX','Window_Message_close','stringify','VisuMZ_2_ExtMessageFunc','_textEffectReturnState','destroy','PulseOffsetX','cos','Window_Message_initMembers','initMembers','updateFlipX','updatePulseX','colorTones','_targetOpacity','textWidth','updateRandomShake','setTextEffectContainer','ConfigManager_applyData','frameCount','updateHueShift','WaveOffsetX','effectData','_AniMsgTextEffectsContainer','fontFace','setHue','ShakeStrengthHorz','length','ColorEffects','IconSet','opacity','return\x200','WaveDistanceX','ceil','updateScaleEffects','normal','process_VisuMZ_AniMsgTextEffects','addChild','buffer','updateOpacityEffects','untitled','contents','toLowerCase','updatePendulumnAngle','iconHeight','PendulumArc','hide','createBitmap','RotationOffset','Window_Message_postFlushTextState','_offset','Window_Message_open','HueShift','open','setupLocation','FlipOffsetX','NUM','updateOriginPosition','children','_rotationAngle','FlipSpeedX','#%1','Window_Message_preFlushTextState','padding','createAllWindows','updateWaveY','processTextEffectCharacter','log','exit','applyColorModifiers','AniMsgTextEffects','iconIndex','WaveSpeedY','max','clearTextEffects','ARRAYEVAL','textColor'];_0x175b=function(){return _0x5edd66;};return _0x175b();}const _0x130864=_0x2e51;(function(_0x7bd94e,_0x1fe286){const _0x4133da=_0x2e51,_0x4453b2=_0x7bd94e();while(!![]){try{const _0xc3f153=parseInt(_0x4133da(0x1ba))/0x1+-parseInt(_0x4133da(0x1b1))/0x2+-parseInt(_0x4133da(0x1b4))/0x3*(parseInt(_0x4133da(0x1a4))/0x4)+parseInt(_0x4133da(0x1a3))/0x5+parseInt(_0x4133da(0x1b5))/0x6*(parseInt(_0x4133da(0x176))/0x7)+-parseInt(_0x4133da(0x1c6))/0x8+parseInt(_0x4133da(0x188))/0x9*(parseInt(_0x4133da(0x173))/0xa);if(_0xc3f153===_0x1fe286)break;else _0x4453b2['push'](_0x4453b2['shift']());}catch(_0x380c6f){_0x4453b2['push'](_0x4453b2['shift']());}}}(_0x175b,0xeff90));function _0x2e51(_0x21339e,_0x4ce3d8){const _0x175b51=_0x175b();return _0x2e51=function(_0x2e51f3,_0x3b3922){_0x2e51f3=_0x2e51f3-0x11d;let _0x5bb370=_0x175b51[_0x2e51f3];return _0x5bb370;},_0x2e51(_0x21339e,_0x4ce3d8);}var label=_0x130864(0x15e),tier=tier||0x0,dependencies=['VisuMZ_1_MessageCore'],pluginData=$plugins[_0x130864(0x1bd)](function(_0x326e9c){const _0x441007=_0x130864;return _0x326e9c[_0x441007(0x1b7)]&&_0x326e9c[_0x441007(0x1ad)][_0x441007(0x1d4)]('['+label+']');})[0x0];VisuMZ[label][_0x130864(0x1a8)]=VisuMZ[label]['Settings']||{},VisuMZ[_0x130864(0x1ae)]=function(_0x42c33c,_0x2b5290){const _0x4e8460=_0x130864;for(const _0x353c47 in _0x2b5290){if(_0x353c47[_0x4e8460(0x197)](/(.*):(.*)/i)){const _0x21ad30=String(RegExp['$1']),_0x3c2f50=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x181b34,_0x475f08,_0x18b525;switch(_0x3c2f50){case _0x4e8460(0x150):_0x181b34=_0x2b5290[_0x353c47]!==''?Number(_0x2b5290[_0x353c47]):0x0;break;case'ARRAYNUM':_0x475f08=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08[_0x4e8460(0x171)](_0x117adf=>Number(_0x117adf));break;case _0x4e8460(0x1c1):_0x181b34=_0x2b5290[_0x353c47]!==''?eval(_0x2b5290[_0x353c47]):null;break;case _0x4e8460(0x163):_0x475f08=_0x2b5290[_0x353c47]!==''?JSON['parse'](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08['map'](_0xc7edcb=>eval(_0xc7edcb));break;case _0x4e8460(0x1c7):_0x181b34=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):'';break;case _0x4e8460(0x1f5):_0x475f08=_0x2b5290[_0x353c47]!==''?JSON['parse'](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08[_0x4e8460(0x171)](_0x4ca9b2=>JSON[_0x4e8460(0x1a7)](_0x4ca9b2));break;case'FUNC':_0x181b34=_0x2b5290[_0x353c47]!==''?new Function(JSON['parse'](_0x2b5290[_0x353c47])):new Function(_0x4e8460(0x137));break;case _0x4e8460(0x191):_0x475f08=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08[_0x4e8460(0x171)](_0x1ff8bf=>new Function(JSON['parse'](_0x1ff8bf)));break;case _0x4e8460(0x1e8):_0x181b34=_0x2b5290[_0x353c47]!==''?String(_0x2b5290[_0x353c47]):'';break;case _0x4e8460(0x1fb):_0x475f08=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08[_0x4e8460(0x171)](_0x1416e6=>String(_0x1416e6));break;case _0x4e8460(0x17e):_0x18b525=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):{},_0x181b34=VisuMZ['ConvertParams']({},_0x18b525);break;case _0x4e8460(0x1e2):_0x475f08=_0x2b5290[_0x353c47]!==''?JSON[_0x4e8460(0x1a7)](_0x2b5290[_0x353c47]):[],_0x181b34=_0x475f08[_0x4e8460(0x171)](_0x4470e4=>VisuMZ[_0x4e8460(0x1ae)]({},JSON['parse'](_0x4470e4)));break;default:continue;}_0x42c33c[_0x21ad30]=_0x181b34;}}return _0x42c33c;},(_0x394ff1=>{const _0x41ecec=_0x130864,_0x42f56b=_0x394ff1[_0x41ecec(0x1bf)];for(const _0x2b9a69 of dependencies){if(!Imported[_0x2b9a69]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x41ecec(0x180)](_0x42f56b,_0x2b9a69)),SceneManager[_0x41ecec(0x15c)]();break;}}const _0x3fa0cd=_0x394ff1[_0x41ecec(0x1ad)];if(_0x3fa0cd['match'](/\[Version[ ](.*?)\]/i)){const _0x2edd1b=Number(RegExp['$1']);_0x2edd1b!==VisuMZ[label][_0x41ecec(0x1ce)]&&(alert(_0x41ecec(0x1b9)[_0x41ecec(0x180)](_0x42f56b,_0x2edd1b)),SceneManager['exit']());}if(_0x3fa0cd['match'](/\[Tier[ ](\d+)\]/i)){const _0x440f13=Number(RegExp['$1']);_0x440f13<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x41ecec(0x180)](_0x42f56b,_0x440f13,tier)),SceneManager['exit']()):tier=Math[_0x41ecec(0x161)](_0x440f13,tier);}VisuMZ[_0x41ecec(0x1ae)](VisuMZ[label][_0x41ecec(0x1a8)],_0x394ff1[_0x41ecec(0x168)]);})(pluginData),VisuMZ[_0x130864(0x15e)][_0x130864(0x19a)]=Scene_Boot['prototype'][_0x130864(0x183)],Scene_Boot['prototype']['onDatabaseLoaded']=function(){const _0x844a7c=_0x130864;VisuMZ[_0x844a7c(0x15e)][_0x844a7c(0x19a)]['call'](this),this['process_VisuMZ_AniMsgTextEffects']();},VisuMZ[_0x130864(0x15e)][_0x130864(0x1eb)]={},Scene_Boot[_0x130864(0x16c)][_0x130864(0x13c)]=function(){const _0x3aa781=_0x130864,_0x58a03a=[_0x3aa781(0x1ab),_0x3aa781(0x134),_0x3aa781(0x17c),_0x3aa781(0x169),_0x3aa781(0x1c9)];for(const _0x383c4b of _0x58a03a){for(const _0x45e50e of VisuMZ['AniMsgTextEffects']['Settings'][_0x383c4b]){if(!_0x45e50e)continue;const _0x1434bb=_0x45e50e[_0x3aa781(0x1bc)][_0x3aa781(0x142)]()['trim']();if(_0x1434bb==='')continue;if(_0x1434bb===_0x3aa781(0x140))continue;VisuMZ['AniMsgTextEffects'][_0x3aa781(0x1eb)][_0x1434bb]=VisuMZ['AniMsgTextEffects'][_0x3aa781(0x1eb)][_0x1434bb]||{};const _0x33374f=VisuMZ[_0x3aa781(0x15e)][_0x3aa781(0x1eb)][_0x1434bb];for(const _0x3cea1a in _0x45e50e){_0x33374f[_0x3cea1a]=_0x45e50e[_0x3cea1a];}if(_0x1434bb===_0x3aa781(0x1a0))console[_0x3aa781(0x15b)](_0x33374f);}}},ConfigManager[_0x130864(0x1c4)]=!![],VisuMZ[_0x130864(0x15e)][_0x130864(0x1e5)]=ConfigManager['makeData'],ConfigManager[_0x130864(0x1f7)]=function(){const _0x4d5eeb=_0x130864,_0x25f5cf=VisuMZ['AniMsgTextEffects']['ConfigManager_makeData'][_0x4d5eeb(0x172)](this);return _0x25f5cf[_0x4d5eeb(0x1c4)]=this[_0x4d5eeb(0x1c4)],_0x25f5cf;},VisuMZ['AniMsgTextEffects']['ConfigManager_applyData']=ConfigManager['applyData'],ConfigManager['applyData']=function(_0x214e52){const _0x5ce6fd=_0x130864;VisuMZ[_0x5ce6fd(0x15e)][_0x5ce6fd(0x12a)]['call'](this,_0x214e52),this[_0x5ce6fd(0x16d)](_0x214e52,_0x5ce6fd(0x1c4),!![]),_0x5ce6fd(0x1c4)in _0x214e52?this[_0x5ce6fd(0x1c4)]=_0x214e52[_0x5ce6fd(0x1c4)]:this[_0x5ce6fd(0x1c4)]=!![];},ColorManager[_0x130864(0x1f6)]=function(_0x4ac5b4){const _0x59d16e=_0x130864;return _0x4ac5b4=String(_0x4ac5b4),_0x4ac5b4[_0x59d16e(0x197)](/#(.*)/i)?_0x59d16e(0x155)[_0x59d16e(0x180)](String(RegExp['$1'])):this['textColor'](Number(_0x4ac5b4));},TextManager[_0x130864(0x1c4)]=VisuMZ['AniMsgTextEffects'][_0x130864(0x1a8)][_0x130864(0x1d2)][_0x130864(0x1bc)]||'',VisuMZ[_0x130864(0x15e)]['Scene_Message_createAllWindows']=Scene_Message[_0x130864(0x16c)][_0x130864(0x158)],Scene_Message[_0x130864(0x16c)][_0x130864(0x158)]=function(){const _0x3aed54=_0x130864;VisuMZ[_0x3aed54(0x15e)]['Scene_Message_createAllWindows'][_0x3aed54(0x172)](this),this['createAniMsgTextEffectsContainer']();},Scene_Message[_0x130864(0x16c)]['createAniMsgTextEffectsContainer']=function(){const _0x1084d6=_0x130864;this['_AniMsgTextEffectsContainer']=new Sprite(),this[_0x1084d6(0x1d7)](this[_0x1084d6(0x12f)]),this['_messageWindow'][_0x1084d6(0x129)](this[_0x1084d6(0x12f)]);};function Sprite_TextEffect(){const _0x3d986d=_0x130864;this[_0x3d986d(0x196)](...arguments);}Sprite_TextEffect['prototype']=Object[_0x130864(0x1cf)](Sprite[_0x130864(0x16c)]),Sprite_TextEffect['prototype'][_0x130864(0x165)]=Sprite_TextEffect,Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x196)]=function(_0xc055e2,_0x574244,_0xf7f69){const _0x33f61f=_0x130864;this[_0x33f61f(0x179)]=_0xc055e2,this[_0x33f61f(0x1af)]=_0xc055e2[_0x33f61f(0x1af)],this[_0x33f61f(0x16b)]=JSON[_0x33f61f(0x1a7)](JSON[_0x33f61f(0x1fe)](_0x574244)),this['_offset']=_0xf7f69,Sprite[_0x33f61f(0x16c)]['initialize'][_0x33f61f(0x172)](this),this[_0x33f61f(0x14e)](),this[_0x33f61f(0x147)](),this[_0x33f61f(0x1ec)](),this[_0x33f61f(0x1b0)]();},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x14e)]=function(){const _0x2af9c2=_0x130864;if(this['_textState'][_0x2af9c2(0x15f)]!==undefined)this[_0x2af9c2(0x1c2)]=ImageManager[_0x2af9c2(0x1a2)]+0x4,this['_textHeight']=ImageManager[_0x2af9c2(0x144)]+0x4;else{const _0x40ba91=this['_textState'][_0x2af9c2(0x13e)];this[_0x2af9c2(0x1c2)]=this[_0x2af9c2(0x179)]['textWidth'](_0x40ba91),this[_0x2af9c2(0x195)]=this[_0x2af9c2(0x16b)][_0x2af9c2(0x16e)];}this[_0x2af9c2(0x17b)]['x']=0.5,this[_0x2af9c2(0x17b)]['y']=0.5;},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x147)]=function(){const _0x29c780=_0x130864;this[_0x29c780(0x16b)]['iconIndex']!==undefined?this[_0x29c780(0x1ed)]():this[_0x29c780(0x1ef)]();},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x1ed)]=function(){const _0x479e3c=_0x130864;this[_0x479e3c(0x1c8)]=ImageManager['loadSystem'](_0x479e3c(0x135));const _0x5dc0e3=ImageManager['iconWidth'],_0x902c3c=ImageManager[_0x479e3c(0x144)],_0x598868=this['_textState']['iconIndex']%0x10*_0x5dc0e3,_0x5007c2=Math[_0x479e3c(0x1e6)](this['_textState'][_0x479e3c(0x15f)]/0x10)*_0x902c3c;this[_0x479e3c(0x1c3)](_0x598868,_0x5007c2,_0x5dc0e3,_0x902c3c);},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x1ef)]=function(){const _0x64536a=_0x130864,_0x5a18f7=this[_0x64536a(0x16b)][_0x64536a(0x13e)],_0x34ce40=Math[_0x64536a(0x139)](this[_0x64536a(0x179)]['textWidth'](_0x5a18f7)*1.5),_0x5c368d=Math[_0x64536a(0x139)](this[_0x64536a(0x16b)][_0x64536a(0x16e)]*1.5);this['bitmap']=new Bitmap(_0x34ce40,_0x5c368d);const _0x524543=this[_0x64536a(0x179)][_0x64536a(0x141)],_0x39c95e=[_0x64536a(0x130),_0x64536a(0x1ea),_0x64536a(0x19f),_0x64536a(0x1be),_0x64536a(0x164),_0x64536a(0x178),'outlineWidth',_0x64536a(0x1f8)];for(const _0x57a8eb of _0x39c95e){this[_0x64536a(0x1c8)][_0x57a8eb]=_0x524543[_0x57a8eb];}const _0x313caa=this[_0x64536a(0x12e)]();_0x313caa[_0x64536a(0x186)]!==undefined&&_0x313caa[_0x64536a(0x186)]!==''&&(this[_0x64536a(0x1c8)][_0x64536a(0x164)]=ColorManager['getColor'](_0x313caa[_0x64536a(0x186)])),this[_0x64536a(0x1c8)]['drawText'](_0x5a18f7,0x0,0x0,_0x34ce40,_0x5c368d,'center');},Sprite_TextEffect['prototype']['createEffectData']=function(){const _0x4d40bc=_0x130864;this[_0x4d40bc(0x1d6)]={};const _0x1cf7d9=this['_textEffect'][_0x4d40bc(0x1c0)](',')['map'](_0xa779f8=>_0xa779f8[_0x4d40bc(0x142)]()[_0x4d40bc(0x16a)]());for(const _0xe4d658 of _0x1cf7d9){const _0x4804e8=VisuMZ['AniMsgTextEffects'][_0x4d40bc(0x1eb)][_0xe4d658];if(!_0x4804e8)continue;for(const _0x47d975 in _0x4804e8){this['_textEffectData'][_0x47d975]=_0x4804e8[_0x47d975];}}},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x12e)]=function(){const _0x526f61=_0x130864;if(this['_textEffectData']===undefined)this[_0x526f61(0x1ec)]();return this[_0x526f61(0x1d6)]||{};},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x1b0)]=function(){const _0x48e36c=_0x130864;Sprite[_0x48e36c(0x16c)][_0x48e36c(0x1b0)][_0x48e36c(0x172)](this),this[_0x48e36c(0x194)](),this[_0x48e36c(0x1b3)](),this[_0x48e36c(0x13a)](),this[_0x48e36c(0x13f)](),this['updateColorEffects']();},Sprite_TextEffect['prototype'][_0x130864(0x194)]=function(){const _0x5c4261=_0x130864;this['updateOriginPosition'](),this['updateRandomShake'](),this[_0x5c4261(0x1dd)](),this[_0x5c4261(0x159)]();},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x151)]=function(){const _0x1e1f1d=_0x130864;this['x']=this[_0x1e1f1d(0x16b)]['x'],this['x']+=this[_0x1e1f1d(0x179)]['x']+this['_msgWindow'][_0x1e1f1d(0x157)],this['x']+=this[_0x1e1f1d(0x1c2)]/0x2,this['y']=this[_0x1e1f1d(0x16b)]['y'],this['y']+=this[_0x1e1f1d(0x179)]['y']+this[_0x1e1f1d(0x179)][_0x1e1f1d(0x157)],this['y']+=this[_0x1e1f1d(0x195)]/0x2;},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x128)]=function(){const _0x51fb7f=_0x130864,_0x19b5dd=this[_0x51fb7f(0x12e)](),_0x24025c=_0x19b5dd[_0x51fb7f(0x132)]??0x0,_0x1d1691=_0x19b5dd[_0x51fb7f(0x18f)]??0x0;if(_0x24025c===0x0&&_0x1d1691===0x0)return;this['x']+=Math[_0x51fb7f(0x1b6)](_0x24025c+0x1)*(Math[_0x51fb7f(0x1c5)]()<0.5?-0x1:0x1),this['y']+=Math['randomInt'](_0x1d1691+0x1)*(Math[_0x51fb7f(0x1c5)]()<0.5?-0x1:0x1);},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x1dd)]=function(){const _0x2a1916=_0x130864,_0x943d35=this[_0x2a1916(0x12e)](),_0x5c148d=_0x943d35[_0x2a1916(0x138)]??0x0;if(_0x5c148d===0x0)return;const _0x49eb91=_0x943d35[_0x2a1916(0x1aa)]??0x0;if(_0x49eb91===0x0)return;const _0x1c504d=_0x943d35[_0x2a1916(0x12d)]??0x0,_0x5caa7c=Graphics[_0x2a1916(0x12b)]+_0x1c504d*this[_0x2a1916(0x14a)];this['x']+=Math[_0x2a1916(0x1a9)](Math['cos'](_0x5caa7c*_0x49eb91)*_0x5c148d);},Sprite_TextEffect[_0x130864(0x16c)]['updateWaveY']=function(){const _0x4c90a5=_0x130864,_0x5a2391=this[_0x4c90a5(0x12e)](),_0x593028=_0x5a2391['WaveDistanceY']??0x0;if(_0x593028===0x0)return;const _0x219c90=_0x5a2391[_0x4c90a5(0x160)]??0x0;if(_0x219c90===0x0)return;const _0x57b046=_0x5a2391['WaveOffsetY']??0x0,_0x5bc504=Graphics[_0x4c90a5(0x12b)]+_0x57b046*this[_0x4c90a5(0x14a)];this['y']+=Math[_0x4c90a5(0x1a9)](Math['cos'](_0x5bc504*_0x219c90)*_0x593028);},Sprite_TextEffect['prototype'][_0x130864(0x1b3)]=function(){const _0x1cd8e0=_0x130864;this[_0x1cd8e0(0x1cc)](),this[_0x1cd8e0(0x143)](),this['updateRotationAngle'](),this[_0x1cd8e0(0x198)]();},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x1cc)]=function(){const _0xd41fe3=_0x130864;this[_0xd41fe3(0x16f)]=0x0,this[_0xd41fe3(0x1ca)]=0x0;},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x143)]=function(){const _0x37f941=_0x130864,_0x133092=this[_0x37f941(0x12e)](),_0x4b6348=_0x133092[_0x37f941(0x145)]??0x0;if(_0x4b6348===0x0)return;const _0xb76d38=_0x133092['PendulumSpeed']??0x0;if(_0xb76d38===0x0)return;const _0x4465d3=_0x133092['PendulumOffset']??0x0,_0x33db97=Graphics[_0x37f941(0x12b)]+_0x4465d3*this['_offset'];this[_0x37f941(0x1ca)]=Math['round'](Math['cos'](_0x33db97*_0xb76d38)*_0x4b6348);},Sprite_TextEffect['prototype'][_0x130864(0x1a1)]=function(){const _0x4d2dd9=_0x130864,_0x180736=this['effectData'](),_0x27eeba=_0x180736['RotationSpeed']??0x0;if(_0x27eeba===0x0)return;const _0xd72ae2=(_0x180736[_0x4d2dd9(0x148)]??0x0)*this['_offset'];this[_0x4d2dd9(0x153)]=this[_0x4d2dd9(0x153)]??_0xd72ae2,this[_0x4d2dd9(0x153)]-=_0x27eeba;while(this[_0x4d2dd9(0x153)]>0x168)this[_0x4d2dd9(0x153)]-=0x168;while(this[_0x4d2dd9(0x153)]<0x0)this['_rotationAngle']+=0x168;},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x198)]=function(){const _0x12c01c=_0x130864;let _0xb7f388=this[_0x12c01c(0x16f)];_0xb7f388+=this['_pendulumAngle'];this[_0x12c01c(0x153)]!==undefined&&(_0xb7f388+=this[_0x12c01c(0x153)]);if(this['angle']!==_0xb7f388)this[_0x12c01c(0x170)]=_0xb7f388;},Sprite_TextEffect['prototype'][_0x130864(0x13a)]=function(){const _0x402b0b=_0x130864;this[_0x402b0b(0x192)](),this['updateFlipX'](),this[_0x402b0b(0x193)](),this[_0x402b0b(0x124)](),this[_0x402b0b(0x19d)](),this[_0x402b0b(0x18b)]();},Sprite_TextEffect['prototype'][_0x130864(0x192)]=function(){const _0xc7a2e7=_0x130864;this[_0xc7a2e7(0x17a)]=0x1,this[_0xc7a2e7(0x179)]&&(this[_0xc7a2e7(0x17a)]*=Math[_0xc7a2e7(0x161)](this[_0xc7a2e7(0x179)]['scale']['x'],this[_0xc7a2e7(0x179)]['scale']['y'])),this['_flipScaleX']=0x1,this[_0xc7a2e7(0x17f)]=0x1,this['_pulseScaleX']=0x1,this[_0xc7a2e7(0x18d)]=0x1;},Sprite_TextEffect['prototype'][_0x130864(0x123)]=function(){const _0x12c0a3=_0x130864,_0x40dc85=this[_0x12c0a3(0x12e)](),_0x1eedb8=_0x40dc85[_0x12c0a3(0x154)]??0x0;if(_0x1eedb8===0x0)return;const _0x182d50=_0x40dc85[_0x12c0a3(0x14f)]??0x0,_0x36fc55=Graphics[_0x12c0a3(0x12b)]+_0x182d50*this['_offset'];this[_0x12c0a3(0x1d1)]=Math[_0x12c0a3(0x120)](_0x36fc55*_0x1eedb8);},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x193)]=function(){const _0x3d1d43=_0x130864,_0x52159a=this['effectData'](),_0x58686c=_0x52159a[_0x3d1d43(0x182)]??0x0;if(_0x58686c===0x0)return;const _0x5e943e=_0x52159a[_0x3d1d43(0x1f0)]??0x0,_0x357b97=Graphics[_0x3d1d43(0x12b)]+_0x5e943e*this[_0x3d1d43(0x14a)];this['_flipScaleY']=Math['cos'](_0x357b97*_0x58686c);},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x124)]=function(){const _0x3081ed=_0x130864,_0x4e9cdc=this['effectData'](),_0x1490c6=(_0x4e9cdc[_0x3081ed(0x174)]??0x0)/0x2;if(_0x1490c6===0x0)return;const _0x239d2b=_0x4e9cdc[_0x3081ed(0x17d)]??0x0;if(_0x239d2b===0x0)return;const _0x50b60b=_0x4e9cdc[_0x3081ed(0x11f)]??0x0,_0x35205c=Graphics[_0x3081ed(0x12b)]+_0x50b60b*this['_offset'];this[_0x3081ed(0x1fc)]+=Math[_0x3081ed(0x120)](_0x35205c*_0x239d2b)*_0x1490c6;},Sprite_TextEffect['prototype'][_0x130864(0x19d)]=function(){const _0x2b0f21=_0x130864,_0x364a4f=this['effectData'](),_0x1ccdb7=(_0x364a4f[_0x2b0f21(0x1df)]??0x0)/0x2;if(_0x1ccdb7===0x0)return;const _0x41237e=_0x364a4f['PulseSpeedY']??0x0;if(_0x41237e===0x0)return;const _0x29482e=_0x364a4f['PulseOffsetY']??0x0,_0x5cbdca=Graphics['frameCount']+_0x29482e*this['_offset'];this[_0x2b0f21(0x18d)]+=Math[_0x2b0f21(0x120)](_0x5cbdca*_0x41237e)*_0x1ccdb7;},Sprite_TextEffect['prototype'][_0x130864(0x18b)]=function(){const _0x42a8e9=_0x130864;let _0x492665=this['_baseScale'];_0x492665*=this[_0x42a8e9(0x1d1)],_0x492665*=this[_0x42a8e9(0x1fc)];let _0x11acd4=this['_baseScale'];_0x11acd4*=this[_0x42a8e9(0x17f)],_0x11acd4*=this[_0x42a8e9(0x18d)];if(this[_0x42a8e9(0x1dc)]['x']!==_0x492665)this['scale']['x']=_0x492665;if(this[_0x42a8e9(0x1dc)]['y']!==_0x11acd4)this[_0x42a8e9(0x1dc)]['y']=_0x11acd4;},Sprite_TextEffect['prototype'][_0x130864(0x13f)]=function(){const _0x1faf12=_0x130864;this[_0x1faf12(0x1e1)](),this[_0x1faf12(0x1a5)](),this['updateGlowEffect'](),this[_0x1faf12(0x18a)]();},Sprite_TextEffect[_0x130864(0x16c)]['setupOpacityModifiers']=function(){const _0x397be7=_0x130864,_0xe6aa57=this[_0x397be7(0x12e)]();this[_0x397be7(0x126)]=_0xe6aa57['InitialOpacity']??0xff;},Sprite_TextEffect['prototype'][_0x130864(0x1a5)]=function(){const _0x550f92=_0x130864,_0x2d5061=this['effectData'](),_0x596da7=(_0x2d5061[_0x550f92(0x1e9)]??'')[_0x550f92(0x142)]()[_0x550f92(0x16a)]();if(_0x596da7==='')return;if(_0x596da7===undefined)return;const _0x55fe73=Math[_0x550f92(0x161)](_0x2d5061['patternDelay']??0x1,0x1),_0x5b7bc3=_0x2d5061[_0x550f92(0x177)]??0x0,_0x1d9da7=Graphics[_0x550f92(0x12b)];this[_0x550f92(0x1ee)]=this[_0x550f92(0x1ee)]??_0x5b7bc3*this[_0x550f92(0x14a)];while(this[_0x550f92(0x1ee)]>=_0x596da7[_0x550f92(0x133)])this[_0x550f92(0x1ee)]-=_0x596da7['length'];while(this[_0x550f92(0x1ee)]<0x0)this[_0x550f92(0x1ee)]+=_0x596da7[_0x550f92(0x133)];const _0x2a6614=(_0x596da7[_0x550f92(0x1d9)](this[_0x550f92(0x1ee)])-0x61)['clamp'](0x0,0x19),_0x128e34=_0x2a6614/0x19;this[_0x550f92(0x126)]*=_0x128e34;if(_0x1d9da7%_0x55fe73===0x0){this[_0x550f92(0x1ee)]++;while(this['_patternIndex']>=_0x596da7[_0x550f92(0x133)])this[_0x550f92(0x1ee)]-=_0x596da7[_0x550f92(0x133)];}},Sprite_TextEffect['prototype'][_0x130864(0x1d3)]=function(){const _0x38bc48=_0x130864,_0x5b94e5=this[_0x38bc48(0x12e)](),_0x14232e=(_0x5b94e5[_0x38bc48(0x1f4)]??0x0)/0x2*0xff;if(_0x14232e===0x0)return;const _0xf7820d=_0x5b94e5[_0x38bc48(0x1d0)]??0x0;if(_0xf7820d===0x0)return;const _0x3f9f3c=_0x5b94e5[_0x38bc48(0x1b8)]??0x0,_0x136ab9=Graphics[_0x38bc48(0x12b)]+_0x3f9f3c*this[_0x38bc48(0x14a)];this[_0x38bc48(0x126)]+=Math['round'](Math['cos'](_0x136ab9*_0xf7820d)*_0x14232e-_0x14232e);},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x18a)]=function(){const _0x5c32c4=_0x130864;this[_0x5c32c4(0x136)]=this[_0x5c32c4(0x126)];},Sprite_TextEffect[_0x130864(0x16c)]['updateColorEffects']=function(){const _0xb30212=_0x130864;this[_0xb30212(0x187)](),this[_0xb30212(0x12c)](),this[_0xb30212(0x1cd)](),this[_0xb30212(0x15d)]();},Sprite_TextEffect[_0x130864(0x16c)]['setupColorModifiers']=function(){},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x12c)]=function(){const _0x7943db=_0x130864,_0x3695f5=this[_0x7943db(0x12e)](),_0x584abb=_0x3695f5[_0x7943db(0x14c)]??0x0;if(_0x584abb===0x0)return;if(this[_0x7943db(0x1e4)]===undefined){const _0xac366f=_0x3695f5[_0x7943db(0x1a6)]??0x0,_0xb539a6=_0xac366f*this[_0x7943db(0x14a)];this[_0x7943db(0x1e4)]=_0xb539a6;}this[_0x7943db(0x1e4)]+=_0x584abb;while(this['_hueValue']>0x168)this[_0x7943db(0x1e4)]-=0x168;while(this[_0x7943db(0x1e4)]<0x168)this['_hueValue']+=0x168;},Sprite_TextEffect['prototype'][_0x130864(0x1cd)]=function(){const _0x5de8f0=_0x130864,_0x50bf44=this[_0x5de8f0(0x12e)](),_0x47f05e=_0x50bf44[_0x5de8f0(0x125)]??[];if(_0x47f05e[_0x5de8f0(0x133)]<=0x0)return;if(this['_currentTone']===undefined){const _0x3ed51d=_0x50bf44[_0x5de8f0(0x181)]??0x0,_0x280d02=Math[_0x5de8f0(0x1e6)](Graphics[_0x5de8f0(0x12b)]/Math['max'](_0x50bf44['toneDelay']??0x1,0x1));this[_0x5de8f0(0x19b)]=_0x3ed51d*this[_0x5de8f0(0x14a)]+_0x280d02;while(this[_0x5de8f0(0x19b)]>=_0x47f05e[_0x5de8f0(0x133)])this[_0x5de8f0(0x19b)]-=_0x47f05e[_0x5de8f0(0x133)];while(this[_0x5de8f0(0x19b)]<0x0)this[_0x5de8f0(0x19b)]+=_0x47f05e[_0x5de8f0(0x133)];this[_0x5de8f0(0x1de)]=_0x47f05e[this[_0x5de8f0(0x19b)]]['clone']();}if(_0x47f05e['length']<=0x1)return;const _0x32be34=Math[_0x5de8f0(0x161)](_0x50bf44[_0x5de8f0(0x167)]??0x1,0x1),_0x3c073d=Graphics[_0x5de8f0(0x12b)];if(_0x3c073d%_0x32be34===0x0){this[_0x5de8f0(0x19b)]++;while(this[_0x5de8f0(0x19b)]>=_0x47f05e[_0x5de8f0(0x133)])this[_0x5de8f0(0x19b)]-=_0x47f05e[_0x5de8f0(0x133)];this['_currentTone']=_0x47f05e[this[_0x5de8f0(0x19b)]][_0x5de8f0(0x1e3)]();}else{if(_0x50bf44['SmoothToneChange']){const _0xcffe13=_0x32be34-_0x3c073d%_0x32be34,_0x1020e8=(this[_0x5de8f0(0x19b)]+0x1)%_0x47f05e['length'],_0x5beb0d=_0x47f05e[_0x1020e8];if(!_0x5beb0d)return;for(let _0x4e2d62=0x0;_0x4e2d62<0x4;_0x4e2d62++){this[_0x5de8f0(0x1de)][_0x4e2d62]=(this[_0x5de8f0(0x1de)][_0x4e2d62]*(_0xcffe13-0x1)+_0x5beb0d[_0x4e2d62])/_0xcffe13;}}}},Sprite_TextEffect[_0x130864(0x16c)][_0x130864(0x15d)]=function(){const _0x56a961=_0x130864;if(this[_0x56a961(0x1e4)]!==undefined)this[_0x56a961(0x131)](this[_0x56a961(0x1e4)]);if(this[_0x56a961(0x1de)]!==undefined)this[_0x56a961(0x1da)](this[_0x56a961(0x1de)]);},VisuMZ['AniMsgTextEffects']['Window_Base_preConvertEscapeCharacters']=Window_Base['prototype'][_0x130864(0x1f1)],Window_Base['prototype'][_0x130864(0x1f1)]=function(_0x2b8c99){const _0x22a9f5=_0x130864;return _0x2b8c99=this[_0x22a9f5(0x1d8)](_0x2b8c99),VisuMZ[_0x22a9f5(0x15e)]['Window_Base_preConvertEscapeCharacters'][_0x22a9f5(0x172)](this,_0x2b8c99);},Window_Base[_0x130864(0x16c)][_0x130864(0x1d8)]=function(_0x2bb7bf){const _0x8e6b42=_0x130864;return _0x2bb7bf=_0x2bb7bf['replace'](/\x1bEFFECT<(.*?)>/gi,''),_0x2bb7bf=_0x2bb7bf[_0x8e6b42(0x184)](/<CLEAR EFFECT(?:|S)>/gi,''),_0x2bb7bf;},VisuMZ['AniMsgTextEffects'][_0x130864(0x1db)]=Window_Base[_0x130864(0x16c)][_0x130864(0x1f9)],Window_Base[_0x130864(0x16c)][_0x130864(0x1f9)]=function(_0x4bdf4a,_0x25c99e){const _0x40860d=_0x130864;if(this[_0x40860d(0x165)][_0x40860d(0x1bf)]==='Window_Message'&&this['_textEffect']&&_0x25c99e[_0x40860d(0x1fa)]){this['processDrawIconTextEffect'](_0x4bdf4a,_0x25c99e);return;}VisuMZ[_0x40860d(0x15e)][_0x40860d(0x1db)][_0x40860d(0x172)](this,_0x4bdf4a,_0x25c99e);},VisuMZ[_0x130864(0x15e)][_0x130864(0x121)]=Window_Message[_0x130864(0x16c)]['initMembers'],Window_Message[_0x130864(0x16c)][_0x130864(0x122)]=function(){const _0x246640=_0x130864;VisuMZ[_0x246640(0x15e)]['Window_Message_initMembers'][_0x246640(0x172)](this),this[_0x246640(0x1af)]='';},Window_Message['prototype'][_0x130864(0x129)]=function(_0x340b93){const _0x46ae49=_0x130864;this[_0x46ae49(0x12f)]=_0x340b93;},Window_Message['prototype'][_0x130864(0x1d8)]=function(_0x18a53c){const _0x203f45=_0x130864;return _0x18a53c=_0x18a53c[_0x203f45(0x184)](/<CLEAR EFFECT(?:|S)>/gi,'\x1bCLEAREFFECT[0]'),_0x18a53c;},VisuMZ[_0x130864(0x15e)][_0x130864(0x1e7)]=Window_Message[_0x130864(0x16c)][_0x130864(0x1f2)],Window_Message[_0x130864(0x16c)][_0x130864(0x1f2)]=function(_0x47b14b,_0x38fcf3){const _0x1f6cec=_0x130864;if(_0x47b14b===_0x1f6cec(0x175)){let _0x7e63fb=this[_0x1f6cec(0x185)](_0x38fcf3);if(_0x38fcf3['drawing']&&ConfigManager[_0x1f6cec(0x1c4)]){_0x7e63fb=_0x7e63fb[_0x1f6cec(0x184)](/\x1bC\[(.*?)\]/gi,''),_0x7e63fb=_0x7e63fb['replace'](/\x1bPREVCOLOR\[(.*?)\]/gi,''),this['_textEffect']=_0x7e63fb[_0x1f6cec(0x142)]()[_0x1f6cec(0x16a)]();if(this[_0x1f6cec(0x1af)]===_0x1f6cec(0x13b))this['_textEffect']='';}}else _0x47b14b===_0x1f6cec(0x1f3)?(this[_0x1f6cec(0x19c)](_0x38fcf3),this[_0x1f6cec(0x1af)]=''):VisuMZ[_0x1f6cec(0x15e)][_0x1f6cec(0x1e7)]['call'](this,_0x47b14b,_0x38fcf3);},VisuMZ[_0x130864(0x15e)][_0x130864(0x156)]=Window_Message[_0x130864(0x16c)][_0x130864(0x18e)],Window_Message[_0x130864(0x16c)][_0x130864(0x18e)]=function(_0x529dd9){const _0x23bc6a=_0x130864;VisuMZ['AniMsgTextEffects']['Window_Message_preFlushTextState'][_0x23bc6a(0x172)](this,_0x529dd9),this[_0x23bc6a(0x1af)]!==''&&_0x529dd9[_0x23bc6a(0x1fa)]&&(this[_0x23bc6a(0x15a)](_0x529dd9),this['_textEffectReturnState']=!![],Imported[_0x23bc6a(0x1bb)]&&this[_0x23bc6a(0x18c)](_0x529dd9),_0x529dd9[_0x23bc6a(0x1fa)]=![]);},VisuMZ[_0x130864(0x15e)][_0x130864(0x149)]=Window_Message[_0x130864(0x16c)][_0x130864(0x1d5)],Window_Message['prototype'][_0x130864(0x1d5)]=function(_0x13f195){const _0x21f3e5=_0x130864;VisuMZ['AniMsgTextEffects']['Window_Message_postFlushTextState'][_0x21f3e5(0x172)](this,_0x13f195),this['_textEffectReturnState']!==undefined&&(_0x13f195[_0x21f3e5(0x1fa)]=!![],this[_0x21f3e5(0x11d)]=undefined,Imported[_0x21f3e5(0x1ff)]&&this['moveCustomMessageCursorPauseSign'](_0x13f195));},Window_Message['prototype']['processTextEffectCharacter']=function(_0x342ce9){const _0x1b3297=_0x130864;if(!this['_AniMsgTextEffectsContainer'])return;const _0x230a70=_0x342ce9[_0x1b3297(0x13e)]['split'](''),_0x396a72=JSON[_0x1b3297(0x1a7)](JSON['stringify'](_0x342ce9));for(const _0x193176 of _0x230a70){_0x396a72[_0x1b3297(0x13e)]=_0x193176;if(_0x193176[_0x1b3297(0x16a)]()!==''){const _0x539adc=this['_AniMsgTextEffectsContainer']['children'][_0x1b3297(0x133)],_0x4ebbb1=new Sprite_TextEffect(this,_0x396a72,_0x539adc);this[_0x1b3297(0x12f)][_0x1b3297(0x13d)](_0x4ebbb1);}const _0x3bafeb=this[_0x1b3297(0x127)](_0x193176);_0x396a72['x']+=_0x3bafeb;}},Window_Base['prototype']['processDrawIconTextEffect']=function(_0x466c9a,_0x22f7b9){const _0x1c3e0e=_0x130864,_0x2c1eb5=JSON[_0x1c3e0e(0x1a7)](JSON[_0x1c3e0e(0x1fe)](_0x22f7b9));_0x2c1eb5[_0x1c3e0e(0x15f)]=_0x466c9a;const _0x154e20=this[_0x1c3e0e(0x12f)][_0x1c3e0e(0x152)][_0x1c3e0e(0x133)],_0x3a4911=new Sprite_TextEffect(this,_0x2c1eb5,_0x154e20);this[_0x1c3e0e(0x12f)][_0x1c3e0e(0x13d)](_0x3a4911),_0x22f7b9['x']+=ImageManager[_0x1c3e0e(0x1a2)]+0x4;},VisuMZ['AniMsgTextEffects']['Window_Message_newPage']=Window_Message[_0x130864(0x16c)][_0x130864(0x1cb)],Window_Message[_0x130864(0x16c)]['newPage']=function(_0x2b1173){const _0x123489=_0x130864;VisuMZ[_0x123489(0x15e)]['Window_Message_newPage'][_0x123489(0x172)](this,_0x2b1173),this[_0x123489(0x1af)]='',this['clearTextEffects']();},Window_Message[_0x130864(0x16c)][_0x130864(0x162)]=function(){const _0x171510=_0x130864;if(!this[_0x171510(0x12f)])return;while(this[_0x171510(0x12f)]['children'][_0x171510(0x133)]>0x0){const _0x542890=this[_0x171510(0x12f)][_0x171510(0x152)][0x0];this[_0x171510(0x12f)][_0x171510(0x190)](_0x542890),_0x542890[_0x171510(0x16b)][_0x171510(0x15f)]===undefined&&_0x542890[_0x171510(0x11e)]();}},VisuMZ['AniMsgTextEffects'][_0x130864(0x14b)]=Window_Message['prototype'][_0x130864(0x14d)],Window_Message[_0x130864(0x16c)][_0x130864(0x14d)]=function(){const _0x3dc52e=_0x130864;VisuMZ[_0x3dc52e(0x15e)][_0x3dc52e(0x14b)][_0x3dc52e(0x172)](this),this[_0x3dc52e(0x12f)]&&this[_0x3dc52e(0x12f)][_0x3dc52e(0x1a0)]();},VisuMZ[_0x130864(0x15e)][_0x130864(0x1fd)]=Window_Message['prototype'][_0x130864(0x1e0)],Window_Message['prototype'][_0x130864(0x1e0)]=function(){const _0x3616fa=_0x130864;VisuMZ[_0x3616fa(0x15e)]['Window_Message_close'][_0x3616fa(0x172)](this),this[_0x3616fa(0x12f)]&&this[_0x3616fa(0x12f)][_0x3616fa(0x146)]();},VisuMZ[_0x130864(0x15e)][_0x130864(0x1b2)]=Window_Options[_0x130864(0x16c)][_0x130864(0x166)],Window_Options[_0x130864(0x16c)][_0x130864(0x166)]=function(){const _0x335ead=_0x130864;VisuMZ['AniMsgTextEffects']['Window_Options_addGeneralOptions']['call'](this),this[_0x335ead(0x199)]();},Window_Options[_0x130864(0x16c)][_0x130864(0x199)]=function(){const _0x28e5ab=_0x130864;VisuMZ[_0x28e5ab(0x15e)][_0x28e5ab(0x1a8)][_0x28e5ab(0x1d2)][_0x28e5ab(0x19e)]&&this[_0x28e5ab(0x1ac)]();},Window_Options[_0x130864(0x16c)][_0x130864(0x1ac)]=function(){const _0x32e041=_0x130864,_0x2d76b3=TextManager['textEffects'],_0x244e93=_0x32e041(0x1c4);this[_0x32e041(0x189)](_0x2d76b3,_0x244e93);};